function [x_new, unfeas, prof] = convModel(x, u, dyn, veh)
%convModel
% Model of a conventional vehicle. Advances the simulation by one timestep.

% States
GN_prev = x{1};

% Controls
GN = u{1};
brakeCmd = u{2};

% Mission information
vehSpd = dyn.vehSpd;
vehAcc = dyn.vehAcc;
vehDist = dyn.vehDist;

% Slope (rad)
vehSlope = atan(dyn.vehGrad/100); % rad

% Longitudinal dynamics
[wheelSpd, wheelTrq, vehPrf, whPrf] = vehDynamicsModel(vehSpd, vehAcc, vehSlope, veh.body, veh.wh);
vehPrf.vehDist = vehDist;

% Brakes
[fdTrqOut, brakeUnfeas, brkPrf] = brakeModel(brakeCmd, wheelTrq);

% Final drive
[fdSpd, fdTrqIn, fdPrf] = finalDriveModel(wheelSpd, fdTrqOut, veh.fd);

% Gearbox
[shaftSpd, shaftTrq, gbPrf] = gearboxModel(fdSpd, fdTrqIn, GN, veh.gb);

% Engine
shaftSpd( shaftSpd < veh.eng.idleSpd & GN <= 1 ) = veh.eng.idleSpd;
[fuelFlwRate, engUnfeas, engPrf] = engineModel(shaftSpd, shaftTrq, veh.eng);

% Update states
x_new = {GN};

% Combine unfeasibilities
unfeas = engUnfeas | brakeUnfeas;
vehPrf.spdUnfeas = engPrf.engSpdUnfeas;
vehPrf.accUnfeas = engPrf.engTrqUnfeas | brakeUnfeas;

% Pack time profiles
prof = mergeStructs(vehPrf, whPrf, fdPrf, gbPrf, engPrf, brkPrf);
prof.time = dyn.time;
prof.unfeas = unfeas;
